---
generated_at: 2026-02-04 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-Security Core 機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. 全主張に根拠あり。決定戦略の詳細実装の確認を推奨。

## 2) 参照した情報（Evidence一覧）
- E-01: `src/Symfony/Component/Security/Core/Authorization/AuthorizationChecker.php`
- E-02: `src/Symfony/Component/Security/Core/Authorization/AccessDecisionManager.php`
- E-03: `src/Symfony/Component/Security/Core/Authentication/Token/TokenInterface.php`
- E-04: `src/Symfony/Component/Security/Core/User/UserInterface.php`
- E-05: `src/Symfony/Component/Security/Core/Authorization/Voter/VoterInterface.php`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`（No.20行）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（画面No.27行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 認証・認可の中核ライブラリ | E-06 | ○ |
| C-02 | AuthorizationCheckerがセキュリティの主エントリーポイント | E-01 (32行目) | ○ |
| C-03 | isGranted()でTokenStorage→NullToken→decide() | E-01 (43-58行目) | ○ |
| C-04 | isGrantedForUser()でOfflineToken生成 | E-01 (60-71行目) | ○ |
| C-05 | AccessDecisionManagerがVoter投票を収集 | E-02 (55-80行目) | ○ |
| C-06 | デフォルト戦略がAffirmativeStrategy | E-02 (49行目) | ○ |
| C-07 | CacheableVoterのsupportsAttribute/supportsTypeキャッシュ | E-02 (107-149行目) | ○ |
| C-08 | collectResultsで各Voterへvote()呼び出し | E-02 (85-102行目) | ○ |
| C-09 | Voter結果のバリデーション（VALID_VOTES） | E-02 (31-35, 91-93行目) | ○ |
| C-10 | accessDecisionStackによるネスト管理 | E-02 (40, 67-79行目) | ○ |
| C-11 | Vote結果記録（voter、result） | E-02 (96-98行目) | ○ |
| C-12 | 複数属性制限（allowMultipleAttributes=false） | E-02 (63-65行目) | ○ |
| C-13 | TokenInterface: getUserIdentifier/getRoleNames/getUser | E-03 (37-51行目) | ○ |
| C-14 | TokenInterface: __serialize/__unserialize | E-03 (79-84行目) | ○ |
| C-15 | UserInterface: getRoles/getUserIdentifier の2メソッド | E-04 (48-55行目) | ○ |
| C-16 | VoterInterface: ACCESS_GRANTED=1/ABSTAIN=0/DENIED=-1 | E-05 (23-25行目) | ○ |
| C-17 | VoterInterface: vote(token, subject, attributes, vote) | E-05 (39行目) | ○ |
| C-18 | tokenStack/accessDecisionStackによる状態管理 | E-01 (34-35行目) | ○ |
| C-19 | TraceableVoter/TraceableAccessDecisionManager存在 | E-02 (18行目), ディレクトリ一覧 | ○ |
| C-20 | セキュリティパネル（画面No.27）との関連 | E-07 | ○ |
| C-21 | Strategy/ディレクトリの存在 | ディレクトリ一覧 | ○ |
| C-22 | ExpressionLanguage/Signature/Validator名前空間の存在 | ディレクトリ一覧 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。主要クラスのソースコードを網羅的に確認済み。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードと整合
- 0: 低リスク - AuthorizationCheckerとAccessDecisionManagerの処理フローは全行確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] AffirmativeStrategy以外の決定戦略の動作が正確に記述されているか確認
- [ ] CacheableVoterのキャッシュ無効化条件が正確か確認
- [ ] OfflineTokenInterfaceの使用シーンが正確か確認
